/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.tenshilib.common.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class MathUtils {
    public static float degToRad(float degree) {
        return degree * ((float)Math.PI / 180);
    }

    public static float radToDeg(float rad) {
        return rad * 57.295776f;
    }

    public static double[] closestOnCircle(double centerX, double centerY, double pointX, double pointY, double radius) {
        double x = pointX - centerX;
        double y = pointY - centerY;
        float d0 = MathHelper.func_76133_a((double)(x * x + y * y));
        return new double[]{x / (double)d0 * radius + centerX, y / (double)d0 * radius + centerY};
    }

    public static double phiFromPoint(double centerX, double centerY, double pointX, double pointY) {
        return Math.atan2(pointY - centerY, pointX - centerX);
    }

    public static List<float[]> pointsOfCircle(float radius, int density) {
        float rad = MathUtils.degToRad(density);
        float i = -rad;
        ArrayList list = Lists.newArrayList();
        while ((double)i < Math.PI * 2) {
            list.add(new float[]{radius * MathHelper.func_76134_b((float)(i += rad)), radius * MathHelper.func_76126_a((float)i)});
        }
        return list;
    }

    public static Vector3d rotate(Vector3d rotAxis, Vector3d vec, float angle) {
        double rot = rotAxis.field_72450_a * vec.field_72450_a + rotAxis.field_72448_b * vec.field_72448_b + rotAxis.field_72449_c * vec.field_72449_c;
        double x = rotAxis.field_72450_a * rot * (double)(1.0f - MathHelper.func_76134_b((float)angle)) + vec.field_72450_a * (double)MathHelper.func_76134_b((float)angle) + (-rotAxis.field_72449_c * vec.field_72448_b + rotAxis.field_72448_b * vec.field_72449_c) * (double)MathHelper.func_76126_a((float)angle);
        double y = rotAxis.field_72448_b * rot * (double)(1.0f - MathHelper.func_76134_b((float)angle)) + vec.field_72448_b * (double)MathHelper.func_76134_b((float)angle) + (rotAxis.field_72449_c * vec.field_72450_a - rotAxis.field_72450_a * vec.field_72449_c) * (double)MathHelper.func_76126_a((float)angle);
        double z = rotAxis.field_72449_c * rot * (double)(1.0f - MathHelper.func_76134_b((float)angle)) + vec.field_72449_c * (double)MathHelper.func_76134_b((float)angle) + (-rotAxis.field_72448_b * vec.field_72450_a + rotAxis.field_72450_a * vec.field_72448_b) * (double)MathHelper.func_76126_a((float)angle);
        return new Vector3d(x, y, z);
    }

    public static Vector3d closestPointToLine(Vector3d point, Vector3d l1, Vector3d dir) {
        return new Vector3d(MathHelper.func_151237_a((double)point.field_72450_a, (double)l1.field_72450_a, (double)dir.field_72450_a), MathHelper.func_151237_a((double)point.field_72448_b, (double)l1.field_72448_b, (double)dir.field_72448_b), MathHelper.func_151237_a((double)point.field_72449_c, (double)l1.field_72449_c, (double)dir.field_72449_c));
    }

    public static Vector3d farestPointToLine(Vector3d point, Vector3d l1, Vector3d dir) {
        return new Vector3d(Math.abs(l1.field_72450_a - point.field_72450_a) > Math.abs(dir.field_72450_a - point.field_72450_a) ? l1.field_72450_a : dir.field_72450_a, Math.abs(l1.field_72448_b - point.field_72448_b) > Math.abs(dir.field_72448_b - point.field_72448_b) ? l1.field_72448_b : dir.field_72448_b, Math.abs(l1.field_72449_c - point.field_72449_c) > Math.abs(dir.field_72449_c - point.field_72449_c) ? l1.field_72449_c : dir.field_72449_c);
    }

    public static double roundTo(double val, double step) {
        return (double)Math.round(val / (double)((float)step)) * step;
    }
}

